//
//	Class definition for the Hummingbird Class
//
//

#ifndef THE_HUMMINGBIRD_CLASS_H
#define THE_HUMMINGBIRD_CLASS_H

//#include "ldwGameState.h"
//#include "WorldMap.h"
//#include "isola.h"
#include "../Game/theGameState.h"
#include "ldwGameWindow.h"
#include "ldwTypes.h"
//#include "theSoundFxManager.h"

//class theGameState;
class ldwGameWindow;

#define maxNumHummingbirds          2
#define defaultHummingbirdAnimSpeed	2
#define numHummingbirdSets			2
#define numHummingbirdFrames        4

#define leftFacingFramesStart   0
#define rightFacingFrameStart   2

#define leftFacing  0
#define rightFacing 1

#define hummerWidth 50

#define leftFacingHummerOffsetX  5
#define rightFacingHummerOffsetX 45
#define hummerOffsetY            24

#define numFeedingSpot 10

typedef enum
{
	eChasing,
	eExit,
	eSpying,
	eFeeding,
	eFeedingFar,

	eFollowingGC,

}
HummingbirdStateType;

typedef struct
{
	ldwPoint	m_sPos;
	ldwPoint	m_sVel;
	ldwPoint	m_sTarget;
	ldwPoint	m_sFeedingTarget;
	int 		type;
	int 		wingPosition;
	int 		wingMotionIdx;
	int 		scale;
	int  		feedingSpotIndex;
	int  		orientation;
	bool 		probing;
	int  		feedingFrameCount;
	int			feedingCyclesRemaining;
	int			spyCause;
	int			waitCycles;
	int			speedScale;

	HummingbirdStateType HummingbirdState;
}
HummingbirdType;

typedef struct
{
	int			x;
	int			y;
	int			orientation;
	bool		gotoNext;
}
FeedingPoint;

class theHummingbirdClass 
{
public:

	static theHummingbirdClass * Get();
	static void Destroy();

	~theHummingbirdClass();

	ldwImageGrid *greenHummingbird;
	void NormVel(int whichHummingbird);
	void AcquireTarget(int whichHummingbird, int x, int y);
	void AcquireTarget(int whichHummingbird);

	void InitHummingbirds();
	void SpawnHummingbirds();
	void UpdateHummingbirds(ldwPoint mousePos);
	void UpdateMiniHummingbirds();
	void DrawHummingbirds();
	void MouseClick(ldwPoint mousePos);

	//array of villager's temporal data
	//tools for set/get of villager's persistant data

	
protected:

	enum
	{
		eCursor,
		eRandom,
		eOtherHummer,
	};

	int  GetFeedingSpot(int notThisIndex = -1);
	int  GetFeedingFarSpot(int notThisIndex = -1);

	void StartFeeding(HummingbirdType *pHummer);
	void InitFeedingTarget(HummingbirdType *pHummer);
	void StartFeedingFar(HummingbirdType *pHummer);
	void InitFarFeedingTarget(HummingbirdType *pHummer);
	void ExitLeftOrRight(HummingbirdType *pHummer,int speedBoost = 0);
	void StartSpying(HummingbirdType *pHummer,int cause);
	void StartChasing(HummingbirdType *pHummer);
	void StartFollowingGC(HummingbirdType *pHummer);


	HummingbirdType hummingbirds[maxNumHummingbirds];

	//protected constructor.  called internally from Get()
	theHummingbirdClass();
	static theHummingbirdClass *mInstance;

	ldwPoint lastMousePos;
	int      mouseHoverCount;

	ldwPoint groupTarget;
	int groupIndexCounter;

	ldwGameWindow *gameWindow;
	theGameState *gs;
};

#endif
